package game;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

import editor.CustomAnimationPanel;

public class CustomImageDataIIRepository  {
	
	private static HashMap<String, CustomImageDataII> imageRepository = new HashMap<String, CustomImageDataII>();
	
	private static HashMap<String, ArrayList<CustomImageDataII>> imagesByRoom = new HashMap<String, ArrayList<CustomImageDataII>>();
	
	private static PurgeThread purgeThread = null;
	private static HashMap<String, LoadingThread> loadingThreads = new HashMap<String, CustomImageDataIIRepository.LoadingThread>();
	
//	private static BufferedWriter outLog;
	
	
	private static DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	
//	static {
//		try {
//			outLog = new BufferedWriter( new FileWriter("c:\\WFMeltdown\\loading out stuff.txt"));
//		} catch(Exception e) {
////			e.printStackTrace();
//		}
//	}
	
	
	public static void purgeEverything() {
		
		if(purgeThread != null) {
			purgeThread.stopThread();
			while(purgeThread.isRunning());
		}
		
		
		LoadingThread l_thread = null;
		
		Set<String> keySet = null;
		
		keySet = loadingThreads.keySet();
		ArrayList<String> keySetSafe = new ArrayList<String>();
		keySetSafe.addAll(keySet);
		
		for(String key : keySetSafe) {
			l_thread = loadingThreads.get(key);
			if(l_thread != null && l_thread.isRunning()) {
				l_thread.stopThread();
				while(l_thread.isRunning());
			}
			loadingThreads.remove(key);
		}
		
		loadingThreads = new HashMap<String, CustomImageDataIIRepository.LoadingThread>();
		
		
		
		keySet = imagesByRoom.keySet();
		
		keySetSafe = new ArrayList<String>();
		keySetSafe.addAll(keySet);
		
		for(String key : keySetSafe) {
			if(imagesByRoom.get(key) != null) {
				imagesByRoom.get(key).clear();
				imagesByRoom.remove(key);
			}
		}
		
		imagesByRoom = new HashMap<String, ArrayList<CustomImageDataII>>();
		
		
		keySet = imageRepository.keySet();
		keySetSafe = new ArrayList<String>();
		keySetSafe.addAll(keySet);
		
		for(String key : keySetSafe) {
			if(imageRepository.get(key) != null) {
				if(imageRepository.get(key).getImage() != null) {
					imageRepository.get(key).getImage().flush();
					imageRepository.get(key).setImage(null);
				}
			}
			imageRepository.remove(key);
		}
		
		imageRepository = new HashMap<String, CustomImageDataII>();
		
		
		
		
	}
	
	
	public static void firePurgeThread(RoomData theRoomData, PonyPanel thePanel) {
		
		if(purgeThread != null) {
			purgeThread.shouldContinue = false;
//			System.out.println("purge thread is still going; we should really stop it at this point...");
			while(purgeThread.isRunning()) {
//				System.out.println("still going...");
				Thread.yield();
			}
		}
		
		purgeThread = new PurgeThread(theRoomData, thePanel);
		Thread t = new Thread(purgeThread);
		t.setPriority(Thread.MIN_PRIORITY);
		t.start();
		
//		System.out.println("purge thread started...");
		
	}
	
	
	public static void addImage(CustomImageDataII image, String roomName) {
		
		imageRepository.put(convertImageToKey(image), image);
		
		ArrayList<CustomImageDataII> allImagesForRoom = imagesByRoom.get(roomName);
		if(allImagesForRoom == null)
			allImagesForRoom = new ArrayList<CustomImageDataII>();
		allImagesForRoom.add(image);
	}
	
	
	public static boolean areAllImagesReadyForRoom(String roomName) {
		
//		if(roomName.equalsIgnoreCase("wfOutside")) {
//			writeToLog("");
//			writeToLog("hum hum hum, now checking to see if " + roomName + " is ready...");
//			writeToLog("");
//		}
		
		ArrayList<CustomImageDataII> allImagesForRoom = imagesByRoom.get(roomName);
		if(allImagesForRoom == null) {
//			if(roomName.equalsIgnoreCase("wfOutside")) {
//				writeToLog("");
//				writeToLog("okay, the arraylist for the room " + roomName + " was null; returning true...");
//				writeToLog("");
//			}
			return true;
		}
		
		for(CustomImageDataII image : allImagesForRoom) {
			if(image.getImage() == null) {
//				if(roomName.equalsIgnoreCase("wfOutside")) {
//					writeToLog("");
//					writeToLog("yes, soemthing in room " + roomName + " was null.  returning false.  thing was: " + convertImageToKey(image));
//					writeToLog("");
//				}
				return false;
			}
		}
		
//		if(roomName.equalsIgnoreCase("wfOutside")) {
//			writeToLog("");
//			writeToLog("hum hum hum hum hum, turns out " + roomName + " is ready.  No null stuff at all.");
//			writeToLog("");
//		}
		return true;
	}
	
	public static double getRoomProgress(String roomName) {
		
		LoadingThread l = loadingThreads.get(roomName);
		
		if(l == null)
			return Double.NaN;
		
		return l.getPercentLoaded();
		
	}
	
	
	public static void fireOffLoadingThread(String theRoomName, boolean shouldBeFromFile, PonyPanel thePanel) {
		LoadingThread existingThread = loadingThreads.get(theRoomName);
		if(existingThread != null && existingThread.isRunning()) {
			existingThread.stopThread();
		}
		
		LoadingThread newThread = new LoadingThread(theRoomName, shouldBeFromFile, thePanel);
		loadingThreads.put(theRoomName, newThread);
		
	}
	
	
	
	public static class LoadingThread implements Runnable {
		
		private String roomName;
		private boolean isFromFile;
		private boolean isRunning;
		private boolean shouldRun;
		private double percentLoaded;
		private PonyPanel ponyPanel;
		
		public LoadingThread(String theRoomName, boolean shouldBeFromFile, PonyPanel thePanel) {
			roomName = theRoomName;
			isFromFile = shouldBeFromFile;
			isRunning = false;
			shouldRun = true;
			percentLoaded = 0.0;
			ponyPanel = thePanel;
			
//			System.out.println("load thread started for room with name: " + theRoomName);
			
//			if(theRoomName.contains("ottling")) {
//				writeToLog("");
//				writeToLog("");
//				writeToLog("now now now now:  now doing a loading thread on the bottling room...");
//				writeToLog("");
//				writeToLog("");
//			}
			
		}
		
		
		@Override
		public void run() {
			
			try {
				
				isRunning = true;
				ArrayList<CustomImageDataII> allImagesForRoom = imagesByRoom.get(roomName);
	//			System.out.println("about to run loading thread for " + roomName);
				
				if(allImagesForRoom == null) {
					isRunning = false;
	//				System.out.println("cancelled loading thread for " + roomName);
					return;
				}
				
	//			System.out.println("proceeding with loading thread for " + roomName + ", allImagesForRoom is: " + allImagesForRoom.size());
				
				percentLoaded = 0.0;
				int numberOfImagesLoaded = 0;
				int numberOfImagesToLoad = allImagesForRoom.size();
				
				
				for(CustomImageDataII anImage : allImagesForRoom) {
					
	//				if(roomName.contains("ottlin")) {
	//					writeToLog("and here we are for roomname: "+roomName+" with im: " + (anImage == null) + "...and if it wasn't null: " + (anImage == null ? "(uh, it IS null)" : ("image name is: " + anImage.getFileName() + ", and buf null? " + (anImage.getImage() == null))));
	//				}
					
					if(anImage.getImage() == null) {
						try {
							
							BufferedImage rawImage = null;
							
							if(!anImage.isResource()) {
								rawImage = ImageIO.read(new File(anImage.getFileName()));
							} else {
								rawImage = ImageIO.read(CustomImageDataII.class.getResource(anImage.getFileName()));
							}
							
							if(anImage.getTransparentColor() != null) {
								rawImage = CustomImageDataII.makeImageTransparent(rawImage, anImage.getTransparentColor());
							}
							
							if(rawImage.getWidth() != anImage.getDesiredWidth() || rawImage.getHeight() != anImage.getDesiredHeight()) {
								rawImage = CustomImageDataII.resizeImage(rawImage, anImage.getDesiredWidth(), anImage.getDesiredHeight(), ponyPanel);
							}
							
							anImage.setImage(rawImage);
							numberOfImagesLoaded++;
							percentLoaded = (1.0 * numberOfImagesLoaded) / (1.0 * numberOfImagesToLoad);
							
	//						System.out.println("<><>DELME about to load up an image; name is: " + anImage.getFileName() + ", percent loaded is: " + percentLoaded);
							
						} catch(Exception e) {
	//						System.err.println("***unable to load image: "  + anImage.getFileName());
	//						e.printStackTrace();
							
	//						try {
	//							PrintWriter out = new PrintWriter(new FileWriter("c:\\WFMeltdown\\errorTrace.txt"));
	//							
	//							e.printStackTrace(out);
	//							
	//							out.flush();
	//							out.close();
	//						} catch (IOException e1) {
	//							// TODO Auto-generated catch block
	////							e1.printStackTrace();
	//						}
						}
					} else {
	//					System.out.println("not loading this image; it's non-null.  Image name: " + anImage.getFileName());
					}
					if(!shouldRun) {
						isRunning = false;
					}
				}
				
				
	//			writeToLog("");
	//			writeToLog("now completed loading thread for room name: " + roomName);
	//			writeToLog("");
				
				isRunning = false;
				
			} catch(Throwable t) {
				
				String traceRaw = PonyPanel.formatStackTrace(t);
				
				traceRaw = traceRaw.replace("\n", "<br>");
				JOptionPane.showMessageDialog(null, "<html>An error occurred in the loading thread:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
				
				System.exit(1);
				
				
			}
		}
		
		public boolean isRunning() {
			return isRunning;
		}
		
		public void stopThread() {
			shouldRun = false;
		}
		
		public double getPercentLoaded() {
			return percentLoaded;
		}
		
	}
	
	
	public static class PurgeThread implements Runnable {
		
		private RoomData roomData;
		private boolean shouldContinue;
		private PonyPanel panel;
		private boolean isRunning;
		
		public PurgeThread(RoomData theRoomData, PonyPanel thePanel) {
			roomData = theRoomData;
			shouldContinue = true;
			panel = thePanel;
			isRunning = false;
			
			
			
//			writeToLog("");
//			writeToLog("");
//			writeToLog("about to fire off a purge thread; this is what's there for the lightning bottling room (we're loadign this room): " + theRoomData.getRoomName());
			
//			ArrayList<CustomImageDataII> list = imagesByRoom.get("lightningBottling");
			
//			if(list != null) {
//				for(int i = 0; i < list.size(); i++) {
//					writeToLog("   here's one: " + list.get(i).getFileName() + ", and do we have an image? " + (list.get(i).getImage()==null));
//				}
//			}
			
//			writeToLog("that's it...");
//			writeToLog("");
//			writeToLog("");
			
//			String key = "C:\\WFMeltdown Project\\wfMeltdown\\src\\images\\bottle dispensor.GIF*255:255:0";
//			writeToLog("oh...and do we have one for this guy:  " + key + "  ; ; ;   " + (imageRepository.containsKey(key) ? ("it's in there, but is the image null? " + (imageRepository.get(key).getImage() == null)) : "the whole thing is null!"));
//			
//			writeToLog("");
//			writeToLog("");
//			writeToLog("");
			
			
			
		}
		
		
		@Override
		public void run() {
			
			isRunning = true;
			try {
				HashSet<String> imagesToBeSpared = new HashSet<String>();
				
				ArrayList<CustomImageDataII> imageList = imagesByRoom.get(roomData.getRoomName());
				
				if(imageList != null) {
					for(CustomImageDataII anImage : imageList) {
						imagesToBeSpared.add(convertImageToKey(anImage));
						if(!shouldContinue) {
							isRunning = false;
							return;
						}
					}
				}
				
				
				RoomData respawnRoom = panel.getRespawnRoom();
				
				if(respawnRoom != null) {
					imageList = imagesByRoom.get(respawnRoom.getRoomName());
					if(imageList != null) {
						for(CustomImageDataII anImage : imageList) {
							imagesToBeSpared.add(convertImageToKey(anImage));
						}
					}
				}
				
				
				
				ArrayList<DoorSprite> doors = roomData.getDoors();
				
				for(DoorSprite door : doors) {
					
					if(door.getDestinationRoom() == null)
						continue;
					
					imageList = imagesByRoom.get(door.getDestinationRoom().getRoomName());
					if(imageList != null) {
						for(CustomImageDataII anImage : imageList) {
							imagesToBeSpared.add(convertImageToKey(anImage));
						}
					}
					
					if(!shouldContinue) {
						isRunning = false;
						return;
					}
					
				}
				
//				System.out.println("<><>DELME got a list of images to be spared...size: " + imagesToBeSpared.size());
				
				Set<String> allImageKeys = imageRepository.keySet();
				
				BufferedImage bi = null;
				
				ArrayList<String> allImageKeysSafe = new ArrayList<String>();
				allImageKeysSafe.addAll(allImageKeys);
				
				for(String key : allImageKeysSafe) {
					
					if(!shouldContinue) {
						isRunning = false;
						return;
					}
					
					if(imagesToBeSpared.contains(key))
						continue;
					
					if(imageRepository.get(key) == null)
					
					bi = imageRepository.get(key).getImage();
					
					if(bi != null) {
						bi.flush();
//						System.out.println("<><>DELME just erased this image: " + key);
					}
					
					imageRepository.get(key).setImage(null);
					
					
					
				}
				
				
//				writeToLog("");
//				writeToLog("purge thread completed for room: " + roomData.getRoomName());
//				writeToLog("");
			} catch(Throwable t) {
//				t.printStackTrace();
				
				String traceRaw = PonyPanel.formatStackTrace(t);
				
				traceRaw = traceRaw.replace("\n", "<br>");
				JOptionPane.showMessageDialog(null, "<html>An error occurred in the purge thread:<br><br>"+traceRaw+"</html>","Error",JOptionPane.ERROR_MESSAGE);
				
				System.exit(1);
				
			}
			isRunning = false;
		}
		
		public void stopThread() {
			shouldContinue = false;
		}
		
		public boolean isRunning() {
			return isRunning;
		}
		
	}
	
	
	
	public static String convertImageToKey(CustomImageDataII image) {
		return image.getFileName() + "*" + CustomAnimationPanel.convertColorToString(image.getTransparentColor()) + "*" + image.getDesiredWidth() + "*" + image.getDesiredHeight();
	}
	
	public static String convertFileAndColorToKey(File theFile, Color transColor) {
		return theFile.getAbsolutePath() + "*" + CustomAnimationPanel.convertColorToString(transColor) + "*rawFile";
	}
	
	public static String convertFileNameAndColorToKey(String theFileName, Color transColor) {
		return theFileName + "*" + CustomAnimationPanel.convertColorToString(transColor) + "*rawPath";
	}
	
	
	public static CustomImageDataII loadImage(String fileName, Color transColor, PonyPanel thePanel, String roomName) {
		
		String key = convertFileNameAndColorToKey(fileName, transColor);

//		if(fileName.contains("conveyor1") ) {
//			try {
//				outLog.write("loading1 up this file: " + fileName + ", this for room " + roomName);
//				outLog.newLine();
//			}catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		if(imageRepository.containsKey(convertFileNameAndColorToKey(fileName, transColor))) {
			//sure, it already exists for the file, but does it exist for the room?
			
			CustomImageDataII returnValue = imageRepository.get(convertFileNameAndColorToKey(fileName, transColor));
			
			boolean alreadyExistsInRoom = false;
			ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
			if(roomImages == null) 
				roomImages = new ArrayList<CustomImageDataII>();
			
			for(CustomImageDataII anImage : roomImages) {
				if(key.equals(convertImageToKey(anImage))) {
					alreadyExistsInRoom = true;
					break;
				}
			}
			
			if(!alreadyExistsInRoom) {
				roomImages.add(returnValue);
				
			} 
			
			imagesByRoom.put(roomName, roomImages);
			
			return returnValue;
		}
		
		CustomImageDataII returnValue = new CustomImageDataII(fileName, transColor, thePanel);
//		if(returnValue.getImage() == null)
//			System.out.println("[][][][][] fileName is: " + fileName);
		returnValue.getImage().flush();
		returnValue.setImage(null);
		imageRepository.put(convertImageToKey(returnValue), returnValue);
		ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
		if(roomImages == null)
			roomImages = new ArrayList<CustomImageDataII>();
		roomImages.add(returnValue);
		imagesByRoom.put(roomName, roomImages);

//		if(fileName.contains("conveyor1")) {
//			try {
//				outLog.newLine();
//				outLog.newLine();
//				outLog.write("okay, okay, okay1 ...it should've added that to the images...let's see what's in there right now: " + returnValue.getDesiredWidth());
//				outLog.newLine();
//				
//				roomImages = imagesByRoom.get(roomName);
//				
//				outLog.write("size of images for room " + roomName + " is: " + (roomImages == null ? "null" : Integer.toString(roomImages.size())));
//				outLog.newLine();
//				
//				for(CustomImageDataII anImage : roomImages) {
//					outLog.write("    " + anImage.getFileName());
//					outLog.newLine();
//				}
//				
//				outLog.newLine();
//				outLog.newLine();
//			} catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		return returnValue;
		
	}
	
	public static CustomImageDataII loadImage(File theFile, Color transColor, PonyPanel thePanel, String roomName, String fileName) {
		
		String key = convertFileNameAndColorToKey(fileName, transColor);
		
//		if(fileName.contains("bottle dispensor") || fileName.contains("corker") || fileName.contains("collector")) {
//			try {
//				outLog.write("loading2 up this file: " + fileName + ", this for room " + roomName);
//				outLog.newLine();
//			}catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		if(imageRepository.containsKey(convertFileNameAndColorToKey(fileName, transColor))) {
			//sure, it already exists for the file, but does it exist for the room?
			
			CustomImageDataII returnValue = imageRepository.get(convertFileNameAndColorToKey(fileName, transColor));
			
			boolean alreadyExistsInRoom = false;
			ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
			if(roomImages == null) 
				roomImages = new ArrayList<CustomImageDataII>();
			
			for(CustomImageDataII anImage : roomImages) {
				if(key.equals(convertImageToKey(anImage))) {
					alreadyExistsInRoom = true;
					break;
				}
			}
			
			if(!alreadyExistsInRoom) {
				roomImages.add(returnValue);
			}
			
			imagesByRoom.put(roomName, roomImages);
			
			return returnValue;
		}
		
		CustomImageDataII returnValue = new CustomImageDataII(theFile, transColor, thePanel);
		returnValue.getImage().flush();
		returnValue.setImage(null);
		imageRepository.put(convertImageToKey(returnValue), returnValue);
		ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
		if(roomImages == null)
			roomImages = new ArrayList<CustomImageDataII>();
		roomImages.add(returnValue);
		imagesByRoom.put(roomName, roomImages);

//		if(fileName.contains("bottle dispensor") || fileName.contains("corker") || fileName.contains("collector")) {
//			try {
//				outLog.newLine();
//				outLog.newLine();
//				outLog.write("okay, okay, okay2 ...it should've added that to the images...let's see what's in there right now: ");
//				outLog.newLine();
//				
//				roomImages = imagesByRoom.get(roomName);
//				
//				outLog.write("size of images for room " + roomName + " is: " + (roomImages == null ? "null" : Integer.toString(roomImages.size())));
//				outLog.newLine();
//				
//				for(CustomImageDataII anImage : roomImages) {
//					outLog.write("    " + anImage.getFileName());
//					outLog.newLine();
//				}
//				
//				outLog.newLine();
//				outLog.newLine();
//			} catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		return returnValue;
		
	}
	
	public static CustomImageDataII loadImage(String fileName, Color transColor, PonyPanel thePanel, int width, int height, String roomName) {
		
		String key = convertFileNameAndColorToKey(fileName, transColor);

//		if(fileName.contains("conveyor")) {
//			try {
//				outLog.write("loading3 up this file: " + fileName + ", this for room " + roomName);
//				outLog.newLine();
//				
//				if(width == 200) {
//					
//					Thread t = Thread.currentThread();
//					StackTraceElement e[] = t.getStackTrace();
//					
//					for(StackTraceElement an : e) {
//						
//						outLog.write("it was 200 all right.  Stack trace: " + an.getClassName() + " : " + an.getMethodName() + ", " + an.getLineNumber());
//						outLog.newLine();
//					}
//				}
//				
//			}catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		if(imageRepository.containsKey(convertFileNameAndColorToKey(fileName, transColor))) {
			//sure, it already exists for the file, but does it exist for the room?
			
			CustomImageDataII returnValue = imageRepository.get(convertFileNameAndColorToKey(fileName, transColor));
			
			boolean alreadyExistsInRoom = false;
			ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
			if(roomImages == null) 
				roomImages = new ArrayList<CustomImageDataII>();
			
			for(CustomImageDataII anImage : roomImages) {
				if(key.equals(convertImageToKey(anImage))) {
					alreadyExistsInRoom = true;
					break;
				}
			}
			
			if(!alreadyExistsInRoom) {
				roomImages.add(returnValue);
				
			}
			
			imagesByRoom.put(roomName, roomImages);
			return returnValue;
		}
		
		CustomImageDataII returnValue = new CustomImageDataII(fileName, transColor, thePanel, width, height);
		returnValue.getImage().flush();
		returnValue.setImage(null);
		imageRepository.put(convertImageToKey(returnValue), returnValue);
		ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
		if(roomImages == null)
			roomImages = new ArrayList<CustomImageDataII>();
		roomImages.add(returnValue);
		imagesByRoom.put(roomName, roomImages);

//		if(fileName.contains("conveyor")) {
//			try {
//				outLog.newLine();
//				outLog.newLine();
//				outLog.write("okay, okay, okay3 ...it should've added that to the images...let's see what's in there right now: " + returnValue.getDesiredWidth() + ", and width wass: " + width);
//				outLog.newLine();
//				
//				roomImages = imagesByRoom.get(roomName);
//				
//				outLog.write("size of images for room " + roomName + " is: " + (roomImages == null ? "null" : Integer.toString(roomImages.size())));
//				outLog.newLine();
//				
//				for(CustomImageDataII anImage : roomImages) {
//					outLog.write("    " + anImage.getFileName());
//					outLog.newLine();
//				}
//				
//				outLog.newLine();
//				outLog.newLine();
//			} catch(Exception e) {
////				e.printStackTrace();
//				JOptionPane.showMessageDialog(null, "","Error occurred", JOptionPane.ERROR_MESSAGE);
//			}
//		}
		
		return returnValue;
		
	}
	
	public static CustomImageDataII loadImage(File theFile, Color transColor, PonyPanel thePanel, int width, int height, String roomName, String fileName) {

		String key = convertFileNameAndColorToKey(fileName, transColor);

//		if(fileName.contains("bottle dispensor") || fileName.contains("corker") || fileName.contains("collector")) {
//			try {
//				outLog.write("loading4 up this file: " + fileName + ", this for room " + roomName);
//				outLog.newLine();
//			}catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		if(imageRepository.containsKey(convertFileNameAndColorToKey(fileName, transColor))) {
			//sure, it already exists for the file, but does it exist for the room?
			
			CustomImageDataII returnValue = imageRepository.get(convertFileNameAndColorToKey(fileName, transColor));
			
			boolean alreadyExistsInRoom = false;
			ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
			if(roomImages == null) 
				roomImages = new ArrayList<CustomImageDataII>();
			
			for(int i = 0; i < roomImages.size(); i++) {
				if(key.equals(convertImageToKey(roomImages.get(i)))) {
					alreadyExistsInRoom = true;
					break;
				}
			}
			
			if(!alreadyExistsInRoom) {
				roomImages.add(returnValue);
				
			} 
			
			
			imagesByRoom.put(roomName, roomImages);
			
//			if(fileName.contains("bottle dispensor") || fileName.contains("corker") || fileName.contains("collector")) {
//				try {
//					outLog.newLine();
//					outLog.newLine();
//					outLog.write("okay, okay, okay4 ...it should've added that to the images...let's see what's in there right now: ");
//					outLog.newLine();
//					
//					roomImages = imagesByRoom.get(roomName);
//					
//					outLog.write("size of images for room " + roomName + " is: " + (roomImages == null ? "null" : Integer.toString(roomImages.size())));
//					outLog.newLine();
//					
//					for(CustomImageDataII anImage : roomImages) {
//						outLog.write("    " + anImage.getFileName());
//						outLog.newLine();
//					}
//					
//					outLog.newLine();
//					outLog.newLine();
//				} catch(Exception e) {
////					e.printStackTrace();
//				}
//			}
			
			
			
			
			return returnValue;
		}
		
		CustomImageDataII returnValue = new CustomImageDataII(theFile, transColor, thePanel, width, height);
		returnValue.getImage().flush();
		returnValue.setImage(null);
		imageRepository.put(convertImageToKey(returnValue), returnValue);
		ArrayList<CustomImageDataII> roomImages = imagesByRoom.get(roomName);
		if(roomImages == null)
			roomImages = new ArrayList<CustomImageDataII>();
		roomImages.add(returnValue);
		imagesByRoom.put(roomName, roomImages);
		
//		if(fileName.contains("bottle dispensor") || fileName.contains("corker") || fileName.contains("collector")) {
//			try {
//				outLog.newLine();
//				outLog.newLine();
//				outLog.write("okay, okay, okay4 ...it should've added that to the images...let's see what's in there right now: ");
//				outLog.newLine();
//				
//				roomImages = imagesByRoom.get(roomName);
//				
//				outLog.write("size of images for room " + roomName + " is: " + (roomImages == null ? "null" : Integer.toString(roomImages.size())));
//				outLog.newLine();
//				
//				for(CustomImageDataII anImage : roomImages) {
//					outLog.write("    " + anImage.getFileName());
//					outLog.newLine();
//				}
//				
//				outLog.newLine();
//				outLog.newLine();
//			} catch(Exception e) {
////				e.printStackTrace();
//			}
//		}
		
		
		return returnValue;
		
	}
	
	public static void fireLoadingThreads(RoomData roomData, boolean shouldBeFromFile, PonyPanel thePanel) {
		
//		if(roomData.getRoomName().equalsIgnoreCase("wfOutside")) {
//			writeToLog("");
//			writeToLog("");
//			writeToLog("fireLoadingThreads for room: " + roomData.getRoomName());
//			writeToLog("");
//			writeToLog("");
//		}
		
		if(loadingThreads == null) {
			loadingThreads = new HashMap<String, CustomImageDataIIRepository.LoadingThread>();
		}
		
		LoadingThread tempThread;
		
		
		tempThread = loadingThreads.get(
				roomData.getRoomName()
				);
		
		if(tempThread != null && tempThread.isRunning()) {
			//what do we do?  ...Let it run?  Yeah, for now.
//			System.out.println("<><>DELME there's already a thread for main room " + roomData.getRoomName() + "; progress is: " + tempThread.getPercentLoaded());
//			if(roomData.getRoomName().equalsIgnoreCase("wfOutside")) {
//				writeToLog("decided not to do this for room " + roomData.getRoomName() + ", since the tempThread is already there.  What's its progress? " + tempThread.getPercentLoaded() + " and is it loading? " + tempThread.isRunning());
//			}
		} else {
			
			tempThread = new LoadingThread(roomData.getRoomName(), shouldBeFromFile, thePanel);
			Thread t = new Thread(tempThread);
			t.setPriority(Thread.MIN_PRIORITY);
			t.start();
			
			loadingThreads.put(roomData.getRoomName(), tempThread);
			
		}
		
		
		ArrayList<DoorSprite> doors = roomData.getDoors();
		
		if(doors == null) {
			return;
		}
		
		for(DoorSprite aDoor : doors) {
			
			if(aDoor.getDestinationRoom() == null)
				continue;
			
			tempThread = loadingThreads.get(aDoor.getDestinationRoom().getRoomName());
			
//			if(roomData.getRoomName().equalsIgnoreCase("wfOutside")) {
//				writeToLog("now considering whether to fire up a thread for this room: " + aDoor.getDestinationRoom().getRoomName());
//			}
			
			if(tempThread != null && tempThread.isRunning()) {
				
//				System.out.println("<><>DELME loadingThread for room " + aDoor.getDestinationRoom().getRoomName() + "already exists; progress: " + tempThread.getPercentLoaded());
//				
//				if(roomData.getRoomName().equalsIgnoreCase("wfOutside")) {
//					writeToLog("decided not to fire off a thread for room " + aDoor.getDestinationRoom().getRoomName() + "; there's already a tempThread.  progress: " + tempThread.getPercentLoaded() + ", running? " + tempThread.isRunning());
//				}
				
			} else {
				
				tempThread = new LoadingThread(aDoor.getDestinationRoom().getRoomName(), shouldBeFromFile, thePanel);
				
				Thread t = new Thread(tempThread);
				t.setPriority(Thread.MIN_PRIORITY);
				t.start();
				loadingThreads.put(aDoor.getDestinationRoom().getRoomName(), tempThread);
				
			}
			
		}
		
//		if(roomData.getRoomName().equalsIgnoreCase("wfOutside")) {
//			writeToLog("");
//			writeToLog("that concludes this call to fireOffThreads.");
//			writeToLog("");
//			writeToLog("");
//		}
	}
	
	
	
	
	public static void fireLoadingThreadsRoomOnly(String roomName, boolean shouldBeFromFile, PonyPanel thePanel) {
		
//		writeToLog("");
//		writeToLog("");
//		writeToLog("fireLoadingThreadsRoomOnly for room: " + roomName);
//		writeToLog("");
//		writeToLog("");
		
		if(loadingThreads == null) {
			loadingThreads = new HashMap<String, CustomImageDataIIRepository.LoadingThread>();
		}
		
		LoadingThread tempThread;
		
		tempThread = loadingThreads.get(roomName);
		
		if(tempThread != null && tempThread.isRunning()) {
			//what do we do?  ...Let it run?  Yeah, for now.
//			System.out.println("<><>DELME there's already a thread for lone room " + roomName + "; progress is: " + tempThread.getPercentLoaded());
//			
//			writeToLog("decided not to do this for lone room " + roomName + ", since the tempThread is already there.  What's its progress? " + tempThread.getPercentLoaded() + " and is it loading? " + tempThread.isRunning());
			
		} else {
			
			tempThread = new LoadingThread(roomName, shouldBeFromFile, thePanel);
			Thread t = new Thread(tempThread);
			t.setPriority(Thread.MIN_PRIORITY);
			t.start();
			
			loadingThreads.put(roomName, tempThread);
			
		}
		
		
		
		
//		writeToLog("");
//		writeToLog("that concludes this call to fireLoadingThreadsRoomOnly.");
//		writeToLog("");
//		writeToLog("");
	}
	
//	
//	public static void dumpEverything() {
//		
//		try {
//			BufferedWriter out = new BufferedWriter(new FileWriter("c:\\WFMeltdown\\dumpFile.txt"));
//			
//			Set<String> keys = imageRepository.keySet();
//			
//			out.write("dump of the whole thing:");
//			out.newLine();
//			out.newLine();
//			out.newLine();
//			
//			out.write("size of the imageRepository: " + imageRepository.size());
//			out.newLine();
//			out.newLine();
//			
//			for(String key : keys) {
//				out.write("a key: " + key + ", null? " + (imageRepository.get(key) == null ? "very much so" : (imageRepository.get(key).getImage() == null ? "yes" : ("no, and here are the image's actual dimensions: " + imageRepository.get(key).getDesiredWidth() + "," + imageRepository.get(key).getDesiredHeight()))));
//				out.newLine();
//			}
//			
//			out.newLine();
//			
//			out.write("that was the imageRepository...");
//			
//			out.newLine();
//			out.newLine();
//			out.newLine();
//			out.newLine();
//			
//			out.write("size of imagesByRoom (i.e. the number of rooms): " + imagesByRoom.size());
//			out.newLine();
//			out.newLine();
//			out.newLine();
//			
//			ArrayList<CustomImageDataII> imageList = null;
//			keys = imagesByRoom.keySet();
//			
//			
//			for(String key : keys) {
//				
//				imageList = imagesByRoom.get(key);
//				
//				out.write("=====> a room: " + key + ", and its list has size: " + imageList.size());
//				out.newLine();
//				for(CustomImageDataII anImage : imageList) {
//					out.write("        image has name: " + convertImageToKey(anImage) + ", and is it null? " + (anImage.getImage() == null ? "yes" : "no"));
//					out.newLine();
//				}
//				
//				
//				out.newLine();
//				
//			}
//			
//			out.newLine();
//			out.newLine();
//			out.newLine();
//			
//			out.write("and now for the loading threads and purge threads...");
//			out.newLine();
//			out.newLine();
//			
//			Set<String> strSet = loadingThreads.keySet();
//			
//			for(String s : strSet) {
//				
//				if(loadingThreads.get(s) == null) {
//					out.write("there was a key: <<" + s + ">>, but it was null!");
//					out.newLine();
//				} else {
//					out.write("for room named <<" + s + ">>, we had a thread.  Running? " + loadingThreads.get(s).isRunning() + ", and progress? " + loadingThreads.get(s).getPercentLoaded());
//					out.newLine();
//				}
//				
//			}
//			
//			out.newLine();
//			out.write("that was all the loading threads!  now for purge thread......");
//			out.newLine();
//			
//			if(purgeThread == null) {
//				out.write("the purge thread is null!");
//			} else {
//				out.write("purge thread is running? " + purgeThread.isRunning() );
//			}
//			
//			out.newLine();
//			out.newLine();
//			
//			out.write("That's everything!");
//			
//			out.flush();
//			out.close();
//		} catch (Exception e) {
////			e.printStackTrace();
//		}
//		
//	}
//	
//	public static void flushLog() {
//		
//		try {
//			outLog.flush();
//			outLog.close();
//		} catch(Exception e) {
////			e.printStackTrace();
//		}
//		
//	}
	
//	public static void writeToLog(String str) {
//		try {
//			
//			outLog.write("[" + df.format(new Date(System.currentTimeMillis())) + "] " + str);
//			outLog.newLine();
//		} catch(Exception e) {
////			e.printStackTrace();
//		}
//	}
}
